//------------------------------------------------------------------------------
// File: svr_gamemode.cs
// This file contains methods to access and manipulate the current game mode
// Author: Matthew Rudge
// Copyright: Sandlot Games, 2007
//------------------------------------------------------------------------------

//! Don't touch this! Use only function accessors
$SLGMODE_CURRENT = $WW2MODE_NONE;

////////////////////////////////////////////////////////////////////////////////
//! Called when the client selects a game mode
//! \param %client Client that issued selection
//! \param %iMode Game mode selected ($WW2MODE_*)
////////////////////////////////////////////////////////////////////////////////
function serverCmdOnGameModeSelect(%client, %iMode)
{
   // Check for validity
   if(%iMode <= $WW2MODE_NONE) {
      return;
   }
   if(%iMode >= $WW2MODE_COUNT) {
      return;
   }
   
   // Set game mode
   slgSetGameMode(%iMode);
}

////////////////////////////////////////////////////////////////////////////////
//! This method changes the current game mode
//! \param %iMode Switches the game mode to one of the defined modes (WW2MODE_*)
////////////////////////////////////////////////////////////////////////////////
function slgSetGameMode(%iMode)
{
   // Already in mode
   if(slgInGameMode(%iMode)) {
      return;
   }
   
   // Set mode
   $SLGMODE_CURRENT = %iMode;
   
   // Notify clients
   %clientCnt = ClientGroup.getCount();
   for(%clientInd = 0; %clientInd < %clientCnt; %clientInd++) {
      %client = ClientGroup.getObject(%clientInd);
      if(isObject(%client)) {
         commandToClient(%client, 'GameModeChanged', $SLGMODE_CURRENT);
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
//! This method checks to see if the game is running in a particular mode
//! \param %iMode Mode to check for
//! \retval bool True if the game is running the mode, false otherwise
////////////////////////////////////////////////////////////////////////////////
function slgInGameMode(%iMode)
{
   return ($SLGMODE_CURRENT == %iMode);
}


function serverCmdSetPortraitTarget(%client, %ghostID)
{
   portraitCameraSetTarget(%client, PortraitCamera, %ghostID);
}

function serverCmdSetTaskPortraitTarget(%client, %ghostID)
{
   portraitCameraSetTarget(%client, TaskPortraitCamera, %ghostID);
}

function portraitCameraSetTarget(%client, %portraitCam, %ghostID)
{
   %component = %portraitCam.getCameraCmp();
   if (isObject(%component) == false)
   {
      return;
   }
   
   if (%ghostID == 0)
   {
      %component.setTarget(0);
      return;
   }

   %target = %client.resolveObjectFromGhostIndex(%ghostID);
   if (isObject(%target) == false)
   {
      return;
   }
   
   %component.setTarget(%target);
}

// this function is called when the game is loaded (notifying the
// building buttons which ones need to be enabled and disabled based
// on the saved tech tree)
function OnTechChange(%techType, %bReqMet)
{
   %client = ClientGroup.getObject(0);
   commandToClient(%client, 'OnTechChange', %techType, %bReqMet);
}

// End svr_gamemode.cs
